# Absolute Policy Optimization

## Installation
Install [mujoco_py](https://github.com/openai/mujoco-py), see the mujoco_py documentation for details. Note that mujoco_py **requires Python 3.6 or greater**.

Install environment:
```
conda create --name apo --file requirements.txt
```

Note that if error reports while installing conda environment. You may choose to first comment the unsupported package, then use `pip install` to install those packages manually. 
```
conda create --name apo 

conda activate apo

pip install -r requirements.txt
```

Due to the recent update of Cython, please update cython version after installation of mujoco-py, or error will be reported when importing mujoco.
```
pip install "cython<3"
```

Afterwards, simply install safe RL environment by:

```
cd safe_rl_envs

pip install -e .
```

## Installation Atari Game Environment 
```
pip install "gymnasium[atari]"

pip install "gymnasium[accept-rom-license]"
```

## Policy Training
Take Goal_Point training for example:
```
cd safe_rl_lib/apo

conda activate apo

python apo.py --task Goal_Point --seed 0
```